require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/worktable.zip"),
	Asset("ATLAS", "images/inventoryimages/millbox.xml")
}

local prefabs =
{
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    local x, y, z = inst.Transform:GetWorldPosition()
    SpawnPrefab("goldnugget").Transform:SetPosition(x, y, z)
	SpawnPrefab("boards").Transform:SetPosition(x, y, z)
    
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end


local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end
local function onactivate(inst)
    inst._activecount = inst._activecount + 1
    --if not inst.SoundEmitter:PlayingSound("sound") then
    --    inst.SoundEmitter:PlaySound("dontstarve/common/ancienttable_craft", "sound")
    --end

    inst:DoTaskInTime(1.5, complete_doonact)
end

local function fn()
    local inst = CreateEntity()
	local kaiguan = 0
	local itemast = 0
	local itemfn = 10
	local dem = 0
	local demfn = 10
	local pm = 0
	local pmfn = 10
	local itemlv = 1
	local demlv = 1
	local pmlv = 1
	local itemkg = 0
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .2)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 2,2 )
    inst.AnimState:SetBank("worktable")
    inst.AnimState:SetBuild("worktable")
    inst.AnimState:PlayAnimation("idle")
    MakeSnowCoveredPristine(inst)
    inst:AddTag("structure")
    inst:AddTag("sign")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	--剧情和升级
   local function OnGetItemFromPlayer(inst, giver, item)
if item.prefab == "study_live" then
    if itemkg == 0
	then itemast = itemast +1  end
--第一幕
    if itemast == 9 and itemlv == 1  then
     itemlv = 2 
    inst.components.talker:Say("鸢一一曹，目前你提供的研究报告已经饱和了" )
	inst:DoTaskInTime(1.5, function()	inst.components.talker:Say("请在第十次提交研究点数时增加提供以下样本") end)
	inst:DoTaskInTime(3, function()	inst.components.talker:Say("蜘蛛腺体x1，蜘蛛丝x1，怪兽肉x5 \n 期待你的下次报告") end) 
     end
     if itemast == 10 and itemlv ==2   then
	      itemkg =1
	     if giver.components.inventory:Has("monstermeat", 5) and giver.components.inventory:Has("silk", 1) and giver.components.inventory:Has("spidergland", 1)and itemkg ==1 then 
		    giver.components.inventory:ConsumeByName("monstermeat", 5)
			giver.components.inventory:ConsumeByName("silk", 1)
			giver.components.inventory:ConsumeByName("spidergland", 1)
            inst.components.talker:Say("感谢你的样本报告，根据AST计划的规定向你开放基础一本科技")
		    itemfn = 20 
		    itemkg = 0
			giver.components.inventory:GiveItem( SpawnPrefab("goldnugget"))
             elseif itemkg ~=0 and itemkg ==1 then 
		    inst.components.talker:Say("提交这次报告时需要上交蜘蛛腺体x1，蜘蛛丝x1，怪兽肉x5")  
			giver.components.inventory:GiveItem( SpawnPrefab("study_live"))
			itemast = 9
	     end
	 end 
end
     if item.prefab == "study_god" then
	     local sp = SpawnPrefab("worktable")
		 local x, y, z = inst.Transform:GetWorldPosition()
	     sp.Transform:SetPosition(x, y, z)
    	 inst:Remove() 
		 
	 end
end
--交易系统
     inst:AddComponent("trader")
	 inst.components.trader:SetAcceptTest(function(inst,item)
	 if item.prefab == "study_god" or item.prefab == "study_live" or item.prefab == "study_war" 
	 then
	 return true
	 end
	 return false
	 end)
	 inst.components.trader.onaccept = OnGetItemFromPlayer
	 --
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
	inst:AddComponent("prototyper")
    inst:AddComponent("lootdropper")
	--报告材料
	inst:AddComponent("talker")
	inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = function(inst,viewer)
	local say = ""
	if kaiguan == 1 then
	inst.components.talker:Say("当前研究进度：  ".."\n 生活："..tostring(itemast)  .."/"..tostring(itemfn).." \n 战斗："..tostring(dem)  .."/"..tostring(demfn).." \n 神代："..tostring(pm)  .."/"..tostring(pmfn)) end
	if kaiguan == 0 then
	inst.components.talker:Say("现在是关机状态") end
	return say
	end
local function turnon(inst)
    inst.components.machine.ison = true
	inst.AnimState:PlayAnimation("work")
	kaiguan = 1

end
local function turnoff(inst)
    inst.components.machine.ison = false
	inst.AnimState:PlayAnimation("idle")
	kaiguan = 0
	
end
	inst:AddComponent("prototyper")
    inst.components.prototyper.onactivate = onactivate
	inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES.TOU_STUDY_TWO
    inst:AddComponent("machine")
    inst.components.machine.turnonfn = turnon
    inst.components.machine.turnofffn = turnoff
	inst:ListenForEvent("onbuilt", onbuilt)
		----保存载入
local function onsave(inst, data)
    data.itemast = itemast
	data.dem = dem
	data.pm = pm
	data.itemfn = itemfn
	data.demfn = demfn
	data.pmfn = pmfn
	data.itemlv = itemlv
	data.demlv = demlv
	data.pmlv = pmlv
	data.itemkg = itemkg
end
 local function onload (inst, data)
    if data ~= nil
     then
		itemast = data.itemast
		dem = data.dem
		pm = data.pm
		itemfn = data.itemfn
		demfn = data.demfn
		pmfn = data.pmfn
		itemlv = data.itemlv
		demlv = data.demlv
		pmlv = data.pmlv
		itemkg = data.itemkg
		print(tostring(itemast));
		print(tostring(dem));
		print(tostring(pm));
		print(tostring(itemfn));
		print(tostring(demfn));
		print(tostring(pmfn));
		print(tostring(itemlv));
		print(tostring(demlv));
		print(tostring(pmlv));
		print(tostring(itemkg));
     end
end	
inst.OnSave = onsave
inst.OnLoad = onload
	   MakeHauntableWork(inst)
    return inst
end
return Prefab("worktable", fn, assets, prefabs),
    MakePlacer("worktable_placer", "worktable", "worktable", "idle")
